#include "customgui_description.h"
#include "c4d_string.h"
#include "c4d_gui.h"


static DescriptionGuiLib *lib = NULL;


static DescriptionGuiLib *CheckPrefsLib(LONG offset)
{
	return (DescriptionGuiLib*)CheckLib(CUSTOMGUI_DESCRIPTION,offset,(C4DLibrary**)&lib);
}


void DescriptionCustomGui::SetObjectList(const AtomArray &list)
{
	DescriptionGuiLib *lib = CheckPrefsLib(LIBOFFSET(DescriptionGuiLib,SetObjectList));
	if (!lib || !lib->SetObjectList) return;

	(((iDescriptionCustomGui*)this)->*(lib->SetObjectList))(list);
}

void DescriptionCustomGui::SetObject(Atom *op)
{
	DescriptionGuiLib *lib = CheckPrefsLib(LIBOFFSET(DescriptionGuiLib,SetObjectList));
	if (!lib || !lib->SetObject) return;

	(((iDescriptionCustomGui*)this)->*(lib->SetObject))(op);
}

Bool DescriptionCustomGui::GetObjectList(AtomArray &list)
{
	DescriptionGuiLib *lib = CheckPrefsLib(LIBOFFSET(DescriptionGuiLib,GetObjectList));
	if (!lib || !lib->GetObjectList) return FALSE;

	return (((iDescriptionCustomGui*)this)->*(lib->GetObjectList))(list);
}

void DescriptionCustomGui::SetMaster(GeDialog *dlg,MasterCallBackFunc *func)
{
	DescriptionGuiLib *lib = CheckPrefsLib(LIBOFFSET(DescriptionGuiLib,SetMaster));
	if (!lib || !lib->SetObject) return;

	(((iDescriptionCustomGui*)this)->*(lib->SetMaster))(dlg,func);
}

GeData DescriptionCustomGui::MasterMessage(const BaseContainer &msg)
{
	DescriptionGuiLib *lib = CheckPrefsLib(LIBOFFSET(DescriptionGuiLib,MasterMessage));
	if (!lib || !lib->GetObjectList) return FALSE;

	return (((iDescriptionCustomGui*)this)->*(lib->MasterMessage))(msg);
}
